<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\RedirectResponse;
use App\Models\Utilisateur;
use Hamcrest\Type\IsBoolean;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): View
    {
        return view('auth.login');
    }

    /**
     * Handle an incoming authentication request.
     */
    public function store(LoginRequest $request): RedirectResponse
    { 
        $selectedUser = Utilisateur::where('login_user',$request->email)
        ->where('password_user',  $request->password)->first();
        //dd($selectedUser);       
        if($selectedUser == null){
            return  false;
        }else{
           //dd("je suis ici OK");       
            return redirect()->intended(RouteServiceProvider::HOME);
        }       
    }

    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }


    public function verifieUserExist($email, $password)
    {
        $selectedUser = Utilisateur::where('login_user',$email)
        ->where('password_user',  $password)->get();
        if($selectedUser == null){
            return  false;
        }else{
            return  true;
        }
    }
}
