<?php

namespace App\Http\Controllers;

use App\Models\Commune;
use App\Models\Gare;
use App\Models\Ligne;
use App\Models\Personne;
use Illuminate\Http\Request;
use Termwind\Components\Li;

class GareController extends Controller
{
    //
    public function index(){
        $allLignes = Ligne::all();
        $allPersonnes = Personne::all();
        $allCommunes = Commune::all();
        $allGares = Gare::orderByDesc('created_at')->with('personne')->with('commune')
                            ->get();
        return view('gare',[
            'allgares' => $allGares,
            'allLignes' => $allLignes,
            'allCommunes' => $allCommunes,
            'allPersonnes' => $allPersonnes
        ]);
    }

    public function store(Request $request)
    {
        try {
        $data = request()->validate([
            'nom_gare' => ['required', 'string'], 
            'ville_gare' => ['required', 'string'], 
            'contact' => ['required', 'string'], 
            'responsable' => ['required', 'string'], 
            'latitude' => ['required', 'string'],
            'longitide' => ['required', 'string']
        ]);
        //dd($data);
        $input['nom_gare'] = $request->nom_gare;
        $input['ville_gare'] = $request->ville_gare;
        $input['contact'] = $request->contact;
        $input['responsable'] = $request->responsable;
        $input['latitude'] = $request->latitude;
        $input['longitide'] = $request->longitide;
        Gare::create($input);
        } catch (\Throwable $th) {
            dd($th->getMessage());
        }
        
        return redirect('/gare')->with('success', 'Opération effectuée avec succès');
    }

    public function editerGare(Request $request)
    {
            $selectGare = Gare::find($request->id);
            $selectGare->update(['nom_gare' => $request->nom_gare,
            'ville_gare' =>$request->ville,
            'contact' =>$request->contact,
            'responsable' =>$request->responsable,
            'latitude' =>$request->latitude,
            'longitide' =>$request->longitide,
           ]);
           return redirect()->back()->with('success', 'Opération effectuée avec succès !');
    }

    public function ajouterLigne(Request $request)
    {
            try {
        $data = request()->validate([
            'ville_deb' => ['required', 'string'], 
            'ville_fin' => ['required', 'string'], 
            'nom_ligne' => ['required', 'string'],
            'distance' => ['required', 'string'],
            'personne_id' => ['required', 'string'],
        ]);
        //dd($request);
        $input['ville_deb'] = $request->ville_deb . '-' .$request->quartier_deb;
        $input['ville_fin'] = $request->ville_fin . '-' . $request->quartier_arr;
        $input['nom_ligne'] = $request->nom_ligne;
        $input['distance'] = $request->distance;
        $input['gare_id'] = $request->id;
        $input['personne_id'] = $request->personne_id;
        Ligne::create($input);

        } catch (\Throwable $th) {
            dd($th->getMessage());
        }
           return redirect()->back()->with('success', 'Opération effectuée avec succès !');
    }

    public function listerLigne(Request $request)
    {
            $selectEntreprise = Gare::find($request->id);
            $allLignes = Ligne::where('gare_id',  $request->id)->get();
           
           return redirect()->back()->with('success', 'Opération effectuée avec succès !');
    }
}
