<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Suivi extends Model
{
    use HasFactory;
    protected $fillable = ['vehicule_id',  'chauffeur_id', 'gare_id', 'day', 'available', 'remarque'];

    public function vehicule()
    {
        return $this->belongsTo(Vehicule::class, 'vehicule_id');
    }

    public function chauffeur()
    {
        return $this->belongsTo(Chauffeur::class, 'chauffeur_id');
    }

    public function gare()
    {
        return $this->belongsTo(Gare::class, 'gare_id');
    }

    public function isAvailable(): bool
    {
        return $this->available && !$this->reservation;
    }

}
