function ajaxCall() {

    this.send = function(data, url, method, success, type) {
        type = type || 'json';
        var successRes = function(data) {
            //alert('TestOK')
            success(data);
            //console.log('AfficheData ' + data)
        }

        var errorRes = function(e) {
            console.log(e);
            //alert('TestNOK')
            //alert("Error found \nError Code: "+e.status+" \nError Message: "+e.statusText);
            //jQuery('#loader').modal('hide');
        }
        jQuery.ajax({
            url: url,
            type: method,
            data: data,
            success: successRes,
            error: errorRes,
            dataType: type,
            timeout: 60000
        });

    }

}

function locationInfo() {
    var rootUrl = "//geodata.solutions/api/api.php";
    //set default values
    var username = 'demo';
    var ordering = 'name';
    //now check for set values
    var addParams = '';
    if (jQuery("#gds_appid").length > 0) {
        addParams += '&appid=' + jQuery("#gds_appid").val();
    }
    if (jQuery("#gds_hash").length > 0) {
        addParams += '&hash=' + jQuery("#gds_hash").val();
    }

    var call = new ajaxCall();



    this.getCountries = function() {
        //get additional fields

        var countryClasses = jQuery('#nationalite_id').attr('class');

        var cC = countryClasses.split(" ");
        cC.shift();
        var addClasses = '';
        if (cC.length > 0) {
            acC = cC.join();
            addClasses = '&addClasses=' + encodeURIComponent(acC);
        }

        var presel = false;
        var iip = 'N';
        jQuery.each(cC, function(index, value) {
            if (value.match("^presel-")) {
                presel = value.substring(7);

            }
            if (value.match("^presel-byi")) {
                var iip = 'Y';
            }
        });


        var url = rootUrl + '?type=getCountries' + addParams + addClasses;
        var method = "post";
        var data = {};
        console.log(url)
            /*  jQuery('.countries').find("option:eq(0)").html("Veuillez patienter ...");*/
        call.send(data, url, method, function(data) {
            /* jQuery('.countries').find("option:eq(0)").html("Sélectionner le pays");*/
            //alert('Country ' + data.hits)


            if (data.tp == 1) {

                console.log('Country ' + data.result)
                if (data.hits > 1000) {
                    //alert('Free usage far exceeded. Please subscribe at geodata.solutions.');
                    console.log('Daily geodata.solutions request limit exceeded:' + data.hits + ' of 1000');
                } else {
                    console.log('Daily geodata.solutions request count:' + data.hits + ' of 1000')
                }
                if (presel == 'byip') {
                    presel = data['presel'];
                    console.log('2 presel is set as ' + presel);
                }


                if (jQuery.inArray("group-continents", cC) > -1) {

                    var $select = jQuery('.countries');
                    console.log(data['result']);
                    jQuery.each(data['result'], function(i, optgroups) {
                        var $optgroup = jQuery("<optgroup>", { label: i });
                        if (optgroups.length > 0) {
                            $optgroup.appendTo($select);
                        }

                        jQuery.each(optgroups, function(groupName, options) {
                            var coption = jQuery('<option />');
                            coption.attr('value', options.name).text(options.name);
                            coption.attr('nationalite_id', options.id);
                            if (presel) {
                                if (presel.toUpperCase() == options.id) {
                                    coption.attr('selected', 'selected');
                                }
                            }
                            coption.appendTo($optgroup);
                        });
                    });
                } else {
                    jQuery.each(data['result'], function(key, val) {
                        var option = jQuery('<option />');
                        option.attr('value', val).text(val);
                        option.attr('nationalite_id', key);
                        if (presel) {
                            if (presel.toUpperCase() == key) {
                                option.attr('selected', 'selected');
                            }
                        }
                        jQuery('.countries').append(option);
                    });
                }
                if (presel) {
                    jQuery('.countries').trigger('change');
                }
                jQuery(".countries").prop("disabled", false);
            } else {
                alert(data.msg);
            }
        });
    };

}


jQuery(function() {
    var loc = new locationInfo();

    loc.getCountries();

    jQuery(".countries").on("change", function(ev) {
        var countryId = jQuery("option:selected", this).attr('nationalite_id');
        if (countryId != '') {
            //loc.getStates(countryId);
        } else {
            jQuery(".states option:gt(0)").remove();
        }
    });

});