@extends('layouts.index')
@section('content')

<div class="pagetitle">
    <h1>Tableau de bord</h1>
</div><!-- End Page Title -->

<section class="section dashboard">
    @if ($message = Session::get('success'))
    <div class="alert alert-success alert-block">
        <button type="button" class="close" data-dismiss="alert">×</button>
        <strong>{{ $message }}</strong>
    </div>
    @endif
    <div class="row col-xl-12">
        <!-- Customers Card -->
        <div class="col-xxl-4 col-xl-4">

            <div class="card info-card">

                <div class="card-body">
                    <h5 class="card-title">TOTAL VEHICULES </h5>

                    <div class="d-flex align-items-center">
                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                            <i class="bi bi-bag-check text-success"></i>
                        </div>
                        <div class="ps-3">
                            <h6> {{ $totalNEW }} </h6>
                            <!--a href="#"> <i class="bi-bag-plus fs-1"></i></a-->
                        </div>
                    </div>
                </div>
                <!-- div class="card-footer">
                            <small class="text-muted">Creer une nouvelle offre</small>
                        </div -->
            </div>
        </div>
        <!-- End Customers Card -->

        <!--Offres Card -->
        <div class="col-xxl-4 col-xl-4">
            <div class="card info-card sales-card">

                <div class="card-body">
                    <h5 class="card-title"> TOTAL CHAUFFEURS</h5>

                    <div class="d-flex align-items-center">
                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                            <i class="bi bi-bag-check text-success"></i>
                        </div>
                        <div class="ps-3">
                            <h6> {{ $totalENC }} </h6>
                        </div>
                    </div>
                </div>
                <!-- div class="card-footer">
                            <a href="#" class="card-link link-success">Tout voir <i class="bi bi-arrow-right-short"></i></a>
                        </div -->
            </div>
        </div><!-- End Offres Card -->

        <!--Offres Card -->
        <div class="col-xxl-4 col-xl-4">
            <div class="card info-card">

                <div class="card-body">
                    <h5 class="card-title">TOTAL TRANSPORTEURS</span></h5>
                    <div class="d-flex align-items-center">
                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                            <i class="bi bi-bag"></i>
                        </div>
                        <div class="ps-3">
                            <h6> {{ $totalEND }} </h6>
                        </div>
                    </div>
                </div>
                <!-- div class="card-footer">
                            <a href="#" class="card-link"> + <i class="bi bi-arrow-right-short"></i></a>
                        </div -->
            </div>
        </div>
    </div>

</section>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">LES ENREGISTREMENTS DE VEHICULE DU JOUR </h5>
                    <!-- Table with stripped rows -->
                    <table class="table datatable">
                        <thead>
                            <tr>
                                <th scope="col">N° CHASSI</th>
                                <th scope="col">IMMATRI.</th>
                                <th scope="col">DATE MISE CIRC.</th>
                                <th scope="col">MODELE</th>
                                <th scope="col">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($allVehicules as $vehicule)
                            <tr>
                                <td>{{ $vehicule->num_chassi }}</td>
                                <td>{{ $vehicule->num_imma}}</td>
                                <td>{{ $vehicule->anne_mc }} </td>
                                <td>{{ $vehicule->modele }} </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-danger dropdown-toggle btn-sm" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                            Actions
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            <li>
                                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#consultvehicule_{{ $vehicule->id }}">DETAIL</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#editvehicule_{{ $vehicule->id }}">MODIFIER</a>
                                            </li>
                                        </ul>
                                    </div>

                                    {{-- Modal POUR CONSULTER --}}
                                    <form action="{{route('consultvehicule')}}" method="POST">
                                        @csrf
                                        {{--@method('PUT')--}}
                                        <div class="modal fade" id="consultvehicule_{{ $vehicule->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">CONSULTER</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <input type="hidden" value="{{ $vehicule->id }}" name="id">
                                                        <div class="row mb-3">

                                                        </div>
                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">Marque :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->marque }}" name="nom" class="form-control" readonly="true">
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">Type Energie:</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->typ_energie }}" name="contactEpoux" class="form-control" readonly="true">
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">Type Véhicule :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->typ_vehicule }}" name="contactEpouse" class="form-control" readonly="true">
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">Puissance Véhicule :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->puis_vehicule }}" name="contactTemoin" class="form-control" readonly="true">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">FERMER</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                    {{-- Modal POUR CONSULTER--}}

                                    
                                    {{-- Modal POUR EDITER --}}
                                    <form action="{{route('editvehicule')}}" method="POST">
                                        @csrf
                                        {{--@method('PUT')--}}
                                        <div class="modal fade" id="editvehicule_{{ $vehicule->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">MODIFICATION VEHICULE</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <input type="hidden" value="{{ $vehicule->id }}" name="id">

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">CHASSI :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->num_chassi }}" name="num_chassi" class="form-control" >
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">MODELE :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->modele }}" name="modele" class="form-control" >
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">MARQUE :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->marque }}" name="marque" class="form-control" >
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">DATE MISE CIRc; :</label>
                                                            <div class="col-sm-8">
                                                                <input type="date" value="{{ $vehicule->anne_mc }}" name="anne_mc" class="form-control" >
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">IMMATRICUAL. :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->num_imma }}" name="num_imma" class="form-control" >
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">TYPE ENERGIE :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->typ_energie }}" name="typ_energie" class="form-control" >
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">TYPE VEHICULE :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->typ_vehicule }}" name="typ_vehicule" class="form-control" >
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">PUISSANCE VEHICULE :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->puis_vehicule }}" name="puis_vehicule" class="form-control" >
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary">Valider</button>
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                                                    </div>
                                                </div>
                                            </div>
                                                    
                                        </div>
                                    </form>
                                    {{-- Modal POUR EDITER--}}

                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!-- End Table with stripped rows -->
                </div>
            </div>

        </div>
    </div>
</section>

@endsection
