@extends('layouts.index')
@section('content')

<div class="pagetitle">
    <h1>GESTION DES RESPONSABLES DE GARE</h1>
</div><!-- End Page Title -->

<section class="section">
    @if ($message = Session::get('success'))
    <div class="alert alert-success alert-block">
        <button type="button" class="close" data-dismiss="alert">×</button>
        <strong>{{ $message }}</strong>
    </div>
    @endif
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Informations...</h5>
                    <!-- General Form Elements -->
                    <form action="{{ url('/personne') }}" method="POST">
                        @csrf
                        <div class="row col-lg-12">
                            <div class="col-lg-12">
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">NOM:</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="nom" class="form-control">
                                    </div>

                                    <label class="col-sm-2 col-form-label">SEXE :</label>
                                    <div class="col-sm-4">
                                        <select class="form-select" name="sexe" aria-label="Default select example">
                                            <option selected>Choisir Ici</option>
                                            <option value="Masculin">Masculin</option>
                                            <option value="Féminin">Féminin</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">PRENOM(S):</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="prenom" class="form-control">
                                    </div>
                                    <label class="col-sm-2 col-form-label">ADRESSE :</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="adresse" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">CONTACT :</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="telephone" class="form-control">
                                    </div>

                                    <label class="col-sm-2 col-form-label">GROUP SANGUIN :</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="groupesanguin" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">E-MAIL :</label>
                                    <div class="col-sm-4">
                                        <input type="mail" name="email" class="form-control">
                                    </div>

                                    <label class="col-sm-2 col-form-label">NATIONALITE :</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="nationalite" class="form-control">
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                        <div class="row col-lg-12">
                            <div class="col-lg-4">
                            </div>
                            <div class="col-lg-4">
                                <div class="row mb-3">
                                    <div class="col-sm-10">
                                        <button type="submit" class="btn btn-danger">ENREGISTRER</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="row mb-3">
                                    <div class="col-sm-10">
                                        <button type="submit" class="btn btn-warning">ANNULER</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!-- End General Form Elements -->
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">LISTE DES RESPONSABLES</h5>
                    <table class="table datatable">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">NOM </th>
                                <th scope="col">PRENOM(S) </th>
                                <th scope="col">CONTACT </th>
                                <th scope="col">SEXE </th>
                                <th scope="col">ADRESSE </th>
                                <th scope="col">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($allPersonnes as $person)
                            <tr>
                                <th scope="row"> </th>
                                <td>{{ $person->nom }}</td>
                                <td>{{ $person->prenom}}</td>
                                <td>{{ $person->telephone }}</td>
                                <td>{{ $person->sexe}}</td>
                                <td>{{ $person->adresse }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-danger dropdown-toggle btn-sm" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                            Actions
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            <li>
                                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#editepersonn_{{ $person->id }}">Modifier</a>
                                            </li>
                                        </ul>
                                    </div>

                                    {{-- Modal POUR EDITER --}}
                                    <form action="{{route('editepersonn')}}" method="POST">
                                        @csrf
                                        {{--@method('PUT')--}}
                                        <div class="modal fade" id="editepersonn_{{ $person->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">Editer</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <input type="hidden" value="{{ $person->id }}" name="id">
                                                        Voulez vous vraiment modifier le responsable : <span class="fw-bold fst-italic">{{ $person->nom }} - {{ $person->prenom }}</span> ?
                                                        <div class="row mb-3">
                                                            <div class="col-sm-8">
                                                                </br>
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">NOM :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $person->nom }}" name="nom" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">PRENOM(S) :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $person->prenom }}" name="prenom" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">TELEPHONE :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $person->telephone }}" name="telephone" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">ADRESSE :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $person->adresse }}" name="adresse" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">SEXE :</label>
                                                            <div class="col-sm-8">
                                                                <select class="form-select" name="sexe" aria-label="Default select example">
                                                                    <option selected>Choisir Ici</option>
                                                                    <option value="Masculin">Masculin</option>
                                                                    <option value="Féminin">Féminin</option>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">GROUPE SANGUIN :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $person->groupesanguin }}" name="gpsanguin" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">NATIONALITE :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $person->nationalite }}" name="nationalite" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">E-MAIL :</label>
                                                            <div class="col-sm-8">
                                                                <input type="mail" value="{{ $person->email }}" name="email" class="form-control">
                                                            </div>
                                                        </div>
                                                    
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary">VALIDER</button>
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">QUITTER</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                    {{-- Modal POUR EDITER--}}
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</section>
@endsection
