@extends('layouts.index')
@section('content')

<div class="pagetitle">
    <h1>GESTION DES VEHICULES</h1>
</div><!-- End Page Title -->

<section class="section">
    @if ($message = Session::get('success'))
    <div class="alert alert-success alert-block">
        <button type="button" class="close" data-dismiss="alert">×</button>
        <strong>{{ $message }}</strong>
    </div>
    @endif
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Informations...</h5>
                    <!-- General Form Elements -->
                    <form action="{{ url('/vehicule') }}" method="POST">
                        @csrf
                        <div class="row col-lg-12">
                            <div class="col-lg-12">
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">NUMERO CHASSI:</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="num_chassi" class="form-control">
                                    </div>

                                    <label class="col-sm-2 col-form-label">NUM. MATRICULE:</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="num_matricule" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">CARTE GRISE :</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="carte_grise" class="form-control">
                                    </div>

                                    <label class="col-sm-2 col-form-label">MODELE :</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="modele" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">MARQUE :</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="marque" class="form-control">
                                    </div>

                                    <label class="col-sm-2 col-form-label">ANNEE MISE EN CIRCUL. :</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="anne_mc" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="row mb-3">
                                    <label class="col-sm-2 col-form-label">TYPE MOTEUR :</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="type_moteur" class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="col-lg-4">
                            </div>
                            <div class="col-lg-4">
                                <div class="row mb-3">
                                    <div class="col-sm-10">
                                        <button type="submit" class="btn btn-danger">ENREGISTRER</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="row mb-3">
                                    <div class="col-sm-10">
                                        <button type="submit" class="btn btn-warning">ANNULER</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!-- End General Form Elements -->
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">LISTE DES VEHICULES</h5>
                    <table class="table datatable">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">NUMERO CHASSI </th>
                                <th scope="col">NUM. MATRICULE </th>
                                <th scope="col">CARTE GRISE </th>
                                <th scope="col">MODELE</th>
                                <th scope="col">MARQUE</th>
                                <th scope="col">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($allVehicules as $vehicule)
                            <tr>
                                <th scope="row"> </th>
                                <td>{{ $vehicule->num_chassi }}</td>
                                <td>{{ $vehicule->num_matricule }}</td>
                                <td>{{ $vehicule->carte_grise }}</td>
                                <td>{{ $vehicule->modele }}</td>
                                <td>{{ $vehicule->marque }}</td>
                                <td>{{ $vehicule->anne_mc }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-danger dropdown-toggle btn-sm" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                            Actions
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                            <li>
                                                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#editevehicule_{{ $vehicule->id }}">Modifier</a>
                                            </li>
                                        </ul>
                                    </div>

                                    {{-- Modal POUR EDITER --}}
                                    <form action="{{route('editevehicule')}}" method="POST">
                                        @csrf
                                        {{--@method('PUT')--}}
                                        <div class="modal fade" id="editevehicule_{{ $vehicule->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">Modification</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <input type="hidden" value="{{ $vehicule->id }}" name="id">
                                                        Voulez vous vraiment modifier la commune : <span class="fw-bold fst-italic">{{ $vehicule->num_chassi }}</span> ?
                                                        <div class="row mb-3">
                                                            <div class="col-sm-8">
                                                                </br>
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">Libellé :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->num_chassi }}" name="nom" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="row mb-3">
                                                            <label class="col-sm-4 col-form-label">Adresse :</label>
                                                            <div class="col-sm-8">
                                                                <input type="text" value="{{ $vehicule->num_matricule }}" name="adresse" class="form-control">
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary">Oui</button>
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Non</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                    {{-- Modal POUR EDITER--}}
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
